#include <GL/glut.h>
#include <iostream>
#include <cstdlib>
#include <cmath>
#include <vector>
using namespace std;

/////////////////////////////
//parse.cpp
//
//GLOBALS
//

#include <cmath>
#include <iostream>
#include <vector>
using std::cout;
using std::cin;
using std::vector;
int gettok(vector<char>&, vector<char>::iterator&);

template <class T>		 
void printVector(const vector< T > &);
void printOpr(const vector< char > &);

// dimensions
GLint hor = 400, ver = 300;

typedef enum {
    S,                 /* shift */
    R,                 /* reduce */
    A,                 /* accept */
    E1,                /* error: missing right parenthesis */
    E2,                /* error: missing operator */
    E3,                /* error: unbalanced right parenthesis */
    E4                 /* error: invalid function argument */
} actEnum;

/* tokens */
typedef enum {
    /* operators */
    tAdd,               /*00 + */
    tSub,               /*01 - */
    tMul,               /*02 * */
    tDiv,               /*03 / */
    tPow,               /*04 ^ (power) */
    tUmi,               /*05 - (unary minus) */
    tFact,              /*06 f(x): factorial */
    tPerm,              /*07 p(n,r): permutations, n objects, r at a time */
    tComb,              /*08 c(n,r): combinations, n objects, r at a time */
    tComa,              /*09 comma */
    tLpr,               /*10 ( */
    tRpr,               /*11 ) */
    tEos,               /*12 end of string */
    tMaxOp,             /*13 maximum number of operators */
    /* non-operators */
    tVal,                /*14 value */
	tVar
} tokEnum;

tokEnum tok, prevtok;   /* tokens */
double tokval;          /* token value */

#define MAX_OPR         50
#define MAX_VAL         50
#define MaxStr			15

// Note use of tMaxOp to count the number of operators on the enum list
char parseTbl[tMaxOp][tMaxOp] = {
    /* stk      ------------------ input ------------------------ */
    /*         +   -   *   /   ^   M   f   p   c   ,   (   )   $  */
    /*         --  --  --  --  --  --  --  --  --  --  --  --  -- */
    /* + */  { R,  R,  S,  S,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* - */  { R,  R,  S,  S,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* * */  { R,  R,  R,  R,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* / */  { R,  R,  R,  R,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* ^ */  { R,  R,  R,  R,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* M */  { R,  R,  R,  R,  R,  S,  S,  S,  S,  R,  S,  R,  R },
    /* f */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  S,  R,  R },
    /* p */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  S,  R,  R },
    /* c */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  S,  R,  R },
    /* , */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  E4},
    /* ( */  { S,  S,  S,  S,  S,  S,  S,  S,  S,  S,  S,  S,  E1},
    /* ) */  { R,  R,  R,  R,  R,  R,  E3, E3, E3, R,  E2, R,  R },
    /* $ */  { S,  S,  S,  S,  S,  S,  S,  S,  S,  E4, S,  E3, A }
};  // $ = Eos?

bool firsttok, erCh = 0;

int error(char *msg) {
    printf("error: %s\n", msg);
    return 1;
}

int shift(double x, vector<char>& vS, vector<char>::iterator& vSIter,vector<char>& opr, vector<double>& val) {
    if (tok == tVal) val.push_back(tokval);
    else if(tok == tVar) val.push_back(x);
	else opr.push_back((char)(tok));
	//get next token
    if (gettok(vS, vSIter)) return 1;
	// successful:
	if(erCh) {
		cout << "\nAfter shift, opr = "; printOpr(opr);
		cout << "\nAfter shift, val = "; printVector(val);
	}
    return 0;
}

double fact(double n) {
    double i, t;
    for (t = 1, i = 1; i <= n; i++)
        t *= i;
    return t;
}

int reduce(vector<char>& opr, vector<double>& val) {
	// check what operation is and reduce accordingly
	switch(opr.back()) { 
    case tAdd:
		if (val.empty()) return error("syntax error"); 
		val[val.size()-2] += val.back(); // add last two items on val stack
        val.pop_back(); // get rid of the last one
        break;
    case tSub:
        if (val.empty()) return error("syntax error");
		val[val.size()-2] -= val.back();
        val.pop_back();;
        break;
    case tMul:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] *= val.back();
        val.pop_back();
        break;
    case tDiv:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] /= val.back();
        val.pop_back();
        break;
    case tUmi:
        if (val.empty()) return error("syntax error");
        val.back() = -val.back();
        break;
    case tPow:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] = pow(val[val.size()-2], val.back());
        val.pop_back();
        break;
    case tFact:
        if (val.empty()) return error("syntax error");
        val.back() = fact(val.back());
        break;
    case tPerm:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] = fact(val[val.size()-1])/fact(val[val.size()-2]-val.back());
        val.pop_back();;
        break;
    case tComb:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] = fact(val[val.size()-2])/
            (fact(val.back()) * fact(val[val.size()-2]-val.back()));
        val.pop_back();;
        break;
    case tRpr:
        /* pop () off stack */
		opr.pop_back();  //amazing how simple this is!
        break;
    }
    opr.pop_back();
	if(erCh) { 
		cout << "\nIn reduce opr = "; printOpr(opr);
		cout << "\nIn reduce val = "; printVector(val);
		cout << "\ntok = " << tok;
	}
    return 0;
}

/////////////////////////////////////////////////////////////
int gettok(vector<char>& vS, vector<char>::iterator& vSIter) {
    //static tokEnum prevtok;  // this declares a new member of the tokEnum list?
	if (firsttok) {  // parse sets the default value of firsttok to true
        firsttok = false; //it's not true anymore!
        prevtok = tEos;  // end of string token
	}
	if (vSIter != vS.end()) {
		switch (*vSIter) {	  
		case '+': {
			tok = tAdd; 
			++vSIter;
			break;  }
		case '-': {
			tok = tSub; 
			++vSIter;
			break;   }
		case '*': {
			tok = tMul; 
			++vSIter;
			break;   }
		case '/': {
			tok = tDiv; 
			++vSIter;
			break;   }
		case '^': {
			tok = tPow; 
			++vSIter;
			break;   }
		case '(': {
			tok = tLpr; 
			++vSIter;
			break;   }
		case ')': {
			tok = tRpr;
			++vSIter;
			break;   }
		case 'x':{
			tok = tVar;
			++vSIter;
			break;   }
		default:
			//convert the following characters into a floating point number
			//  floats can have 7 digits of precision, but we will allow the
			//  user to input as much as they want.
			//First, check to make sure that it is indeed a number
			if (!isdigit(*vSIter)) {
				cout << "\nunknown command\n";
				return false;
			}
			tok = tVal;
			char tempval[MaxStr];
			int i = 0;
			for(;vSIter!=vS.end() && (isdigit(*vSIter) || *vSIter == '.');++vSIter) {
				tempval[i++] = *vSIter;
			}
			tempval[i] = '\0';
			tokval = atof(tempval);
		}  //no scientic notation power of 10?
	}
	else {
		tok = tEos;
	}
	
    /* check for unary minus - disambiguation */
    if (tok == tSub) {
        if (prevtok != tVal && prevtok != tVar && prevtok != tRpr) {
            tok = tUmi;
        }
    }
	if(erCh) { cout << "\nprevtok = " << prevtok; cout << "\n"; }
    prevtok = tok;
	return 0;
}



double parse(double x, vector<char>& vS, vector<char>::iterator& vSIter,
		  vector<char>& opr, vector<double>& val) {
	/* initialize for next expression */
    opr.push_back(tEos); // also if no recognized char	
	firsttok = true;
	if (gettok(vS, vSIter)) return 1; //if you didn't get through gettok on the first go, abort
    /* scan symbols into ? */
	while(1) {
        /* input is value so accumulate digits until not a value */
		if (tok == tVal || tok == tVar) { 
			/* shift token to value stack */
            if (shift(x, vS, vSIter, opr, val)) return 1;
            continue;
        }
		if(erCh) cout << "\nparseTbl["<<(tokEnum)opr.back()<<"]["<<(tokEnum)tok<<"]="<<parseTbl[opr.back()][tok];
        /* input is operator */
		switch(parseTbl[opr.back()][tok]) { //follow precedence
        case R:   
			if (reduce(opr, val)) return 1;
            break;
        case S:
            if (shift(x, vS, vSIter, opr, val)) return 1;
            break;
        case A:
            /* accept */
			if (val.size() != 1) return error("syntax error");
            return val.back();//0;
        case E1:
            return error("missing right parenthesis");
        case E2:
            return error("missing operator");
        case E3:
            return error("unbalanced right parenthesis");
        case E4:
            return error("invalid function argument");
        }
    }
}




template <class T>		 
void printVector(const vector< T > &v) {  
 vector<T>::const_iterator i = v.begin();
 for( ; i != v.end(); ++i) {
  cout << *i << " ";
 }
}


void printOpr(const vector< char > &v) {  
 vector<char>::const_iterator i = v.begin();
  //  cout << endl;
 for( ; i != v.end(); ++i) {
  if (*i==tAdd) cout << "+";
  if (*i==tSub) cout << "-";
  if (*i==tLpr) cout << "(";
  if (*i==tRpr) cout << ")";
  if (*i==tMul) cout << "*";
  if (*i==tDiv) cout << "/";
  if (*i==tPow) cout << "^";
  if (*i==tEos) cout << "$";
 }
}

//<<<<<<<<<<<<<<<<<<<<<<< init >>>>>>>>>>>>>>>>>>>>
void init(void){
	glClearColor(1.0,1.0,1.0,0.0); //white background
	glColor3f(0.0f, 0.0f, 0.0f); //black drawing
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//set the viewing coordinates
	gluOrtho2D(0.0, hor, 0.0, ver);
}
//<<<<<<<<<<<<<<<<<<<<<<<< mouse >>>>>>>>>>>>>>>>>
void mouse(int button, int state, int x, int y) {
//to be added later
}
//<<<<<<<<<<<<<<<<<<<<<<<< display >>>>>>>>>>>>>>>>>
void display(void){
	glClear(GL_COLOR_BUFFER_BIT); // clear the screen
	glLineWidth(2.0);
	GLfloat red=0.0, green=0.0, blue=1.0;
	double x, y, ymax, ymin, m; // variable
	static char str[MaxStr]=""; // static means it retains its value, even when out of scope 
	vector<char> vString(MaxStr); /* expression string */
	vector<char>::iterator vSIter = vString.begin();
	vector<char> opr(MAX_OPR); /* operator stack */
	vector<double> val(MAX_VAL);/* value stack */
	vector<double> yVals;  yVals.clear();
	vector<double>::iterator yIter = yVals.begin();
	//double xcent = (double)hor/2;
	//double ycent = (double)ver/2;
	//while(*str != 'q') {
	vString.clear();
	// Input the expression
	cout << "\nEnter a function of x (q to quit):\n";
	//cin.getline(str, MaxStr);//gets(str); 
	cin >> str;
	//if(str=="q") break;
	for(int i = 0; i != strlen(str); ++i) {
		if(str[i] != ' ') {
			vString.push_back(str[i]);
		}
	}
	vSIter = vString.begin();
	if(*str!='q') {
		glColor3f(red,green,blue);
		for(x = -5.; x <= 5.; x += 1.) {
			opr.clear();
			val.clear();
			vSIter = vString.begin();
			yIter = yVals.begin();
			y = parse(x, vString, vSIter, opr, val);
            yVals.push_back(y);
			cout << "\n(x,y) = " << "("<<x <<", "<<y<<")";
		}
		ymax = yVals[0]; ymin = yVals[0];
		// get max and min y-vals to scale window
		for(yIter = yVals.begin(); yIter != yVals.end(); ++yIter) {
			if(*yIter>ymax) ymax = *yIter;
			if(*yIter<ymin) ymin = *yIter;
		}
		m = (double)ver/(ymax - ymin);
		for(yIter = yVals.begin(); yIter != yVals.end(); ++yIter) 
			*yIter = m*(*yIter - ymin);
        yIter = yVals.begin();
		glBegin(GL_LINES);
   			for(x = 0; x < (double)hor; x += (double)hor/10.) { 
              glVertex2f(x,*yIter);
			  glVertex2f(x+(double)hor/10.,*(++yIter));
		      red += 0.1;
			  blue -= 0.1;
			  glColor3f(red,green,blue);
			}
			
		glEnd();
	}
	//glPopMatrix();
	glFlush(); // send all output to display
}


int main(int argc, char** argv) {
	glutInit(&argc, argv); // initialize the toolkit
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowSize(hor, ver); // set window size
    // set window position on screen
	glutInitWindowPosition(450, 400);
	// open the screen window and set the name
	glutCreateWindow("Function Plotter");
	//register your functions
	init();	
	glutDisplayFunc(display);
	//glutMouseFunc(mouse);
	glutMainLoop(); // go into a perpetual loop
    return 0;
}
