#include <iostream>
#include <cstdlib>
//#include <string>
#include <cmath>
#include <vector>
using namespace std;

int gettok();

template <class T>		 
void printVector(const std::vector< T > &);

void printOpr(const std::vector< char > &);

/////////////////////////////
//GLOBALS
bool another;  // for doing another parse
bool firsttok;
int nestLevel;

/* actions */
typedef enum {
    S,                 /* shift */
    R,                 /* reduce */
    A,                 /* accept */
    E1,                /* error: missing right parenthesis */
    E2,                /* error: missing operator */
    E3,                /* error: unbalanced right parenthesis */
    E4                 /* error: invalid function argument */
} actEnum;

/* tokens */
typedef enum {
    /* operators */
    tAdd,               /*00 + */
    tSub,               /*01 - */
    tMul,               /*02 * */
    tDiv,               /*03 / */
    tPow,               /*04 ^ (power) */
    tUmi,               /*05 - (unary minus) */
    tFact,              /*06 f(x): factorial */
    tPerm,              /*07 p(n,r): permutations, n objects, r at a time */
    tComb,              /*08 c(n,r): combinations, n objects, r at a time */
    tComa,              /*09 comma */
    tLpr,               /*10 ( */
    tRpr,               /*11 ) */
    tEos,               /*12 end of string */
    tMaxOp,             /*13 maximum number of operators */
    /* non-operators */
    tVal                /*14 value */
} tokEnum;

tokEnum tok, prevtok;   /* tokens */
double tokval;          /* token value */

#define MAX_OPR         50
#define MAX_VAL         50
#define MaxStr			15

vector<char> vString(MaxStr); /* expression string */
std::vector<char>::iterator vSIter = vString.begin();//const_       static 
vector<char> opr(MAX_OPR); /* operator stack */
vector<double> val(MAX_VAL);/* value stack */

// Note use of tMaxOp to count the number of operators on the enum list
char parseTbl[tMaxOp][tMaxOp] = {
    /* stk      ------------------ input ------------------------ */
    /*         +   -   *   /   ^   M   f   p   c   ,   (   )   $  */
    /*         --  --  --  --  --  --  --  --  --  --  --  --  -- */
    /* + */  { R,  R,  S,  S,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* - */  { R,  R,  S,  S,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* * */  { R,  R,  R,  R,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* / */  { R,  R,  R,  R,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* ^ */  { R,  R,  R,  R,  S,  S,  S,  S,  S,  R,  S,  R,  R },
    /* M */  { R,  R,  R,  R,  R,  S,  S,  S,  S,  R,  S,  R,  R },
    /* f */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  S,  R,  R },
    /* p */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  S,  R,  R },
    /* c */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  S,  R,  R },
    /* , */  { R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  R,  E4},
    /* ( */  { S,  S,  S,  S,  S,  S,  S,  S,  S,  S,  S,  S,  E1},
    /* ) */  { R,  R,  R,  R,  R,  R,  E3, E3, E3, R,  E2, R,  R },
    /* $ */  { S,  S,  S,  S,  S,  S,  S,  S,  S,  E4, S,  E3, A }
};  // $ = Eos?

int error(char *msg) {
    printf("error: %s\n", msg);
    return 1;
}

int shift(void) {
    if (tok == tVal) {
		val.push_back(tokval);
    } else {
		opr.push_back((char)(tok));
    }
	//get next token
    if (gettok()) return 1;
	// successful:
	cout << "\nAfter shift, opr = "; printOpr(opr);
	cout << "\nAfter shift, val = "; printVector(val);
    return 0;
}

double fact(double n) {
    double i, t;
    for (t = 1, i = 1; i <= n; i++)
        t *= i;
    return t;
}

int reduce(void) {
	// check what operation is and reduce accordingly
	switch(opr.back()) { 
    case tAdd:
		if (val.empty()) return error("syntax error"); 
		val[val.size()-2] += val.back(); // add last two items on val stack
        val.pop_back(); // get rid of the last one
        break;
    case tSub:
        if (val.empty()) return error("syntax error");
		val[val.size()-2] -= val.back();
        val.pop_back();;
        break;
    case tMul:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] *= val.back();
        val.pop_back();
        break;
    case tDiv:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] /= val.back();
        val.pop_back();
        break;
    case tUmi:
        if (val.empty()) return error("syntax error");
        val.back() = -val.back();
        break;
    case tPow:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] = pow(val[val.size()-2], val.back());
        val.pop_back();
        break;
    case tFact:
        if (val.empty()) return error("syntax error");
        val.back() = fact(val.back());
        break;
    case tPerm:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] = fact(val[val.size()-1])/fact(val[val.size()-2]-val.back());
        val.pop_back();;
        break;
    case tComb:
        if (val.empty()) return error("syntax error");
        val[val.size()-2] = fact(val[val.size()-2])/
            (fact(val.back()) * fact(val[val.size()-2]-val.back()));
        val.pop_back();;
        break;
    case tRpr:
        /* pop () off stack */
		opr.pop_back();  //does this really do it?if(nestLevel > 0) 
		//else reduce();//while(opr.back()!=tLpr) { cout << "\nha"; reduce(); }
		//cout << "\nopr.back() = " << opr.back();
        break;
    }
    opr.pop_back();
	cout << "\nIn reduce opr = "; printOpr(opr);
	cout << "\nIn reduce val = "; printVector(val);
	cout << "\ntok = " << tok;
    return 0;
}

/////////////////////////////////////////////////////////////
int gettok() {
    //static tokEnum prevtok;  // this declares a new member of the tokEnum list?
	if (firsttok) {  // parse sets the default value of firsttok to true
        firsttok = false; //it's not true anymore!
        prevtok = tEos;  // end of string token
	}
	if(vString.size() == 1 && vString[0] == '0') {
		another = 0;
		return 1;
	}
	//std::vector<char>::const_iterator vSIter = vString.begin(); 
	if (vSIter != vString.end()) {
        //cout << "\n*vSIter = " << *vSIter;
		switch (*vSIter) {	  
		case '+': {
			//cout << "\nGot a +";
			tok = tAdd; //opr.push_back(tAdd);
			++vSIter;//*str++;
			break;  }
		case '-': {
			tok = tSub; //opr.push_back(tSub);
			++vSIter;//*str++;
			break;   }
		case '*': {
			tok = tMul; //opr.push_back(tMul);
			++vSIter;//*str++;
			break;   }
		case '/': {
			tok = tDiv; //opr.push_back(tDiv);
			++vSIter;//*str++;
			break;   }
		case '^': {
			tok = tPow; //opr.push_back(tPow);
			++vSIter;//*str++;
			break;   }
		case '(': {
			tok = tLpr; //opr.push_back(tLpr);
			++vSIter;//*str++;
			//++nestLevel;
			break;   }
		case ')': {
			tok = tRpr; //opr.push_back(tRpr);
			//--nestLevel;
			 ++vSIter;//if(nestLevel == 0)
			break;   }
		default:
			//convert the following characters into a floating point number
			//  floats can have 7 digits of precision, but we will allow the
			//  user to input as much as they want.
			//First, check to make sure that it is indeed a number
			if (!isdigit(*vSIter)) {
				cout << "\nunknown command\n";
				return false;
			}
			tok = tVal;
			char tempval[MaxStr];
			int i = 0;
			//cout << "\n*vSIter = " << *vSIter;
			for(;vSIter!=vString.end() && (isdigit(*vSIter) || *vSIter == '.');++vSIter) {
				tempval[i++] = *vSIter;
			}
			//cout << "\ntokval = " << tokval;
			tempval[i] = '\0';
			tokval = atof(tempval);
		}  //no scientic notation power of 10?
	}
	else {
		tok = tEos;
	}
	
    /* check for unary minus - disambiguation */
    if (tok == tSub) {
        if (prevtok != tVal && prevtok != tRpr) {
            tok = tUmi;
        }
    }
	cout << "\nprevtok = " << prevtok;
    prevtok = tok;
    cout << "\n";//tok = " << tok;
    return 0;
}

int parse() {
	/* initialize for next expression */
    opr.push_back(tEos); // also if no recognized char	
	firsttok = true;
	if (gettok()) return 1; //if you didn't get through gettok on the first go, abort
    /* scan symbols into ? */
	//cout << "\ngot first token, tok = " << tok;
    while(1) {
        /* input is value so accumulate digits until not a value */
		if (tok == tVal) { 
			/* shift token to value stack */
            if (shift()) return 1;
            continue;
        }
		cout << "\nparseTbl["<<(tokEnum)opr.back()<<"]["<<(tokEnum)tok<<"]="<<parseTbl[opr.back()][tok];
        /* input is operator */
		switch(parseTbl[opr.back()][tok]) { //follow precedence
        case R:   
			if (reduce()) return 1;
            break;
        case S:
            if (shift()) return 1;
            break;
        case A:
            /* accept */
			//printVector(val);
            if (val.size() != 1) return error("syntax error");
            //cout <<  "value = \n" << val.back(); //[valTop]);
            return 0;
        case E1:
            return error("missing right parenthesis");
        case E2:
            return error("missing operator");
        case E3:
            return error("unbalanced right parenthesis");
        case E4:
            return error("invalid function argument");
        }
    }
}

template <class T>		 
void printVector(const std::vector< T > &v) {  
 std::vector<T>::const_iterator i = v.begin();
    //cout << endl;
 for( ; i != v.end(); ++i) {
  cout << *i << " ";
 }
}

void printOpr(const std::vector< char > &v) {  
 std::vector<char>::const_iterator i = v.begin();
  //  cout << endl;
 for( ; i != v.end(); ++i) {
  if (*i==tAdd) cout << "+";
  if (*i==tSub) cout << "-";
  if (*i==tLpr) cout << "(";
  if (*i==tRpr) cout << ")";
  if (*i==tMul) cout << "*";
  if (*i==tDiv) cout << "/";
  if (*i==tPow) cout << "^";
  if (*i==tEos) cout << "$";
 }
}
int main(void) {
	another = true;
	static char str[MaxStr]; // static means it retains its value, even when out of scope 
	while(another) {
		//clear the decks 
		opr.clear();
		val.clear();
		vString.clear();
		nestLevel = 0;
		// Input the expression
		cout << "\nenter expression (0 to quit):\n";
		//cin.getline(str, MaxStr);//gets(str); 
		cin >> str;
		for(int i = 0; i < strlen(str); ++i) {
			//cout << str[i];
			if(str[i] != ' ') {
				vString.push_back(str[i]);
				//cout << vString.back();
			}
		}
		//vString.push_back(tEos);
		cout << "\nBefore parse, string = "; printVector(vString);
		//cout << "\nvString = "; printVector(vString);
		vSIter = vString.begin();
		parse(); cout << "\n = ";
		printVector(val);
	}
    return 0;
}
