#include<iostream>
#include<ctime>
#include<cstdlib>
#include<vector>
#include<fstream>
using namespace std;

const char c[] = {'1','(','/',')','/'};

void printVector(const vector<char> &);
void writeVector(ostream &, const vector<char> &);
void getNblob(vector<char> &, const char [], int);
void getRevBlob(vector<char> &, vector<char> &);
void conv2nums(vector<char> &, vector<char> &);
void getLower(vector<char> &, vector<char> &);
void getCanForm(vector<char> &, vector<char> &);
void updateList(vector<vector<char> > &, vector<char> &, int);
void xlate(vector<char> &, vector<char> &, int);
void conv2strng(vector<char> &, vector<char> &);


int main() {
	// globGenus is the number of blobs in the glob
    int globGenus, guessCount = 0, i, j, reset = 0, guess;
    vector<char> vChar, vStrng, vlownum;
    vector<vector<char> > cforms;
    srand(time(0));
    // open a file
    ofstream outBlob("blobs.txt", ios::out);
    if(!outBlob) { 
                 cerr << "\ndoh!" << endl;
                 exit(1);
    } 
    while(1) {
        cforms.clear();     
        cout << endl << endl << "\nWhat's the blob index? ";
        cin >> globGenus; guessCount = 0;
        cout << endl << "\nHow many guesses? ";
        cin >> guess;
        while (guessCount < guess) {
           vChar.clear();
           getNblob(vChar, c, globGenus);       
           getCanForm(vChar, vlownum);
           updateList(cforms, vlownum, reset);
//           nextCycle(cforms, vChar, reset);             
           if (reset == 1) guessCount = 0;              
           ++guessCount;
        }
        cout << endl << "Forms for index " << globGenus << " = " << cforms.size();
        j = 0;
        cout << endl <<endl;
        vector<vector<char> >::iterator mrIt = cforms.begin();
        vector<char> vInsrt(8,'x');
               
//        for( ; mrIt < cforms.end(); ++mrIt) printVector(*mrIt);
//        cout << endl;
//        cforms.insert(cforms.begin()+2, 1, vInsrt);     
//        for(mrIt = cforms.begin(); mrIt < cforms.end(); ++mrIt) printVector(*mrIt);
        cout << "cforms.size = " << cforms.size();
        do {
           conv2strng(cforms[j], vStrng);
           printVector(vStrng);
           writeVector(outBlob, vStrng);
           ++j;
        } while (j < cforms.size());   
   }
}
void getCanForm(vector<char> &vChar, vector<char> &vlownum) {
     int i = 1; char z;
     vector<char> vCharRev, vNums, vXlate;
     vXlate.clear(); vCharRev.clear(); 
     vNums.clear(); vlownum.clear();
//     printVector(vChar); //cout << " orig";
     for (int j=0; j < vChar.size(); ++j) vlownum.push_back('5');
     conv2nums(vChar, vNums);
     getLower(vNums, vlownum);
     getRevBlob(vChar, vCharRev);
     conv2nums(vCharRev, vNums);
     getLower(vNums, vlownum);
     while (i < vChar.size()) {       
           if (vChar[i] == '1') { 
              xlate(vChar, vXlate, i);
//              printVector(vChar);  cout << " orig";
              conv2nums(vXlate, vNums);
              getLower(vNums, vlownum);
              getRevBlob(vXlate, vCharRev);  
              conv2nums(vCharRev, vNums);
              getLower(vNums, vlownum);
//              cin >> z;
//              printVector(vXlate);  cout << " xlate pos. " << i+1;
//              cin >> z;
           }
           ++i;
     }            
//     printVector(vlownum);
}
void updateList(vector<vector<char> > &cforms, vector<char> &vlownum, int reset) {
     char z;
     vector<vector<char> >::iterator cfIt = cforms.begin();
     reset = 0;
     //cout << "cforms.size = " << cforms.size(); cin >> z;
     if (cforms.size() == 0) cforms.push_back(vlownum);
     else if(vlownum > *(cforms.end()-1)) cforms.push_back(vlownum);
     else {
//        for (int j = 0; j < cforms.size(); ++j) printVector(cforms[j]);
         while ((vlownum > *cfIt) && (cfIt != cforms.end())) ++cfIt;
         if (vlownum < *cfIt) {
           //cforms.push_back(vector<char>());
           cforms.insert(cfIt, 1, vlownum);
           reset = 1;
         }
     }               
//     cout << endl;
//     for (j = 0; j < cforms.size(); ++j) printVector(cforms[j]);
}
// Translates string (vChar) from the perspective of the '1' in position i. 
// rndx and lndx move left and right out from i.  ss tells if you: 0 - have not  
// yet hit a slash or containing paren, 1 - have hit a slash (so must cont. to 
// containing paren), or 2 - have hit the containing paren and are done with 
// current side of loop.
void xlate(vector<char> &vChar, vector<char> &vXlate, int i) {
     int lndx, rndx, j, k, ss, rdone = 0, ldone = 0, dzp, max = vChar.size() - 1;
     vector<char> vNew;
     char x;
     vNew.clear(); vXlate.clear();
     for (j = 0; j <= max; ++j) {
         vXlate.push_back('0');
         vNew.push_back('0');  }
     vNew[0] = '1'; vNew[i] = '1';
     if (i == max) rdone = 1;
     else rndx = i + 1;
     if (i == 1) ldone = 1;
     else lndx = i - 1;
//     cout << "i = " << i << ", max = " << max << " rdone = " << rdone << " ldone = " << ldone;
//     cin >> x;
     do { // big loop
        if (rdone == 0) {
            ss = 0;
//            cout << endl << endl << "RIGHT SIDE";
            do {  // right side
               switch (vChar[rndx])  {
                      case '1':
                           vNew[rndx] = '1';
                           if (rndx == max) rdone = 1; 
                           else ++rndx;
                           break;
                      case '(':  //  a '(' going rt means there is a dead zone
                           vNew[rndx] = '(';
                           dzp = 1;
                           do {
                              ++rndx;
                              vNew[rndx] = vChar[rndx];
                              if (vChar[rndx] == '(') ++dzp;
                              if (vChar[rndx] == ')') --dzp;
//                              cout << "case '(' ";
//                              cout << endl << "rndx = " << rndx << "  ss = " << ss;
 //                             cout << endl << "dzp = " << dzp;
                           } while (dzp > 0);
                           if (rndx == max) rdone = 1; 
                           else ++rndx;
                           break;
                      case '/':
                           if (ss == 0) {
                              vNew[rndx] = '(';
                              ss = 1; }
                           else vNew[rndx] = '/';
                           ++rndx; 
                           break;
                      case ')':
                           if (ss == 0) vNew[rndx] = '(';
                           else vNew[rndx] = '/';
                           ss = 2;
                           if (rndx == max) rdone = 1; 
                           else ++rndx; 
                           break;
               }  // endswitch
//               cout << endl <<"rndx = " << rndx << " vChar[" << rndx << "] = " << vChar[rndx];         
//               cout << endl << "rdone = " << rdone << "    ldone = " << ldone;
//               cout << "   ss = " << ss;
//               printVector(vNew);
//               cout << endl; cin >> x;
            } while ((ss < 2) && (rdone == 0));
        }   //endif
        if (ldone == 0) {
            ss = 0;
//            cout << endl << endl << "LEFT SIDE"; cin >>x;
            do {  // left side       
               switch (vChar[lndx]) {
                      case '1': 
                           vNew[lndx] = vChar[lndx];
                           if (lndx == 1) ldone = 1;
                           if (lndx == 0) ldone = 1;
                           else --lndx;                            
                           break;
                      case ')':
                           vNew[lndx] = ')';
                           dzp = 1;
                           do  {
                               --lndx;
                               vNew[lndx] = vChar[lndx];
                               if (vChar[lndx] == ')') ++dzp;
                               if (vChar[lndx] == '(') --dzp;
//                              cout << "case ')' ";
//                              printVector(vChar); cout << "  vChar";
//                              printVector(vNew); cout << "  vNew";
//                              cout << endl << "lndx = " << lndx << "  ss = " << ss;
//                              cout << endl << "vChar[" << lndx << "] = " << vChar[lndx];
//                              cout << "  dzp = " << dzp;
//                              cin >> x;
                           } while (dzp > 0);
                           if (lndx == 1) ldone = 1;
                           else --lndx; 
                           break;
                      case '/':
                           if (ss == 0) {
                              vNew[lndx] = ')';
                              ss = 1;  }
                           else vNew[lndx] = '/';
                           --lndx; 
                           break;
                      case '(':
                           if (ss == 0) vNew[lndx] = ')';
                           else vNew[lndx] = '/';
                           ss = 2;
                           if(lndx == 1) ldone = 1; 
                           else --lndx;
                           break;
               }   //  end switch
//               cout << endl <<"lndx = " << lndx << " vChar[" << lndx << "] = " << vChar[lndx];          
//               cout << endl << "rdone = " << rdone << "    ldone = " << ldone;                
//               cout << "  ss = " << ss;
//               printVector(vNew);   
//               cout << endl;
//               cin >> x;    
            } while ((ss < 2) && (ldone == 0));        
        }  // endif
     } while ((ldone == 0) || (rdone == 0));
     for (k = 0; k <= max; ++k) 
         vXlate[k]= vNew[(k+i)% (max+1)];
}                                   
void getLower(vector<char> &vNums, vector<char> &vlownum)  {
     int i = 0, j,done = 0;
     do  {
             // cout << "vNums[" << i << "] = " << vNums[i];
             // cout << "  vlownum[" << i << "] = " << vlownum[i];
             // cout << endl;
             if (vNums[i] < vlownum[i]) {
                for (j = 0; j < vNums.size(); ++j) 
                    vlownum[j] = vNums[j];
                done = 1;
             }
             if (vNums[i] > vlownum[i]) done = 1;          
             if (i == vNums.size()) done = 1;
             ++i;
         } while (done == 0);
}     
void getRevBlob(vector<char> &vChar, vector<char> &vCharRev) {
     int i = 1, j = vChar.size();
     vCharRev.clear();
     vCharRev.push_back('1');
     while (i < j) {
           switch (vChar[j-i]) {
                 case '1':
                      vCharRev.push_back('1');
                      ++i; break;
                 case '(':   
                      vCharRev.push_back(')');
                      ++i; break;
                 case '/':
                      vCharRev.push_back('/');
                      ++i; break;
                 case ')':   
                      vCharRev.push_back('(');
                      ++i; break;     
            } // end switch          
     }
}
void conv2nums(vector<char> &vChar, vector<char> &vNums)  {
     int i = 0;
     vNums.clear();
     while (i < vChar.size()) {
           switch (vChar[i]) {
                  case '1':
                       vNums.push_back('1');
                       ++i; break;
                  case '(':
                       vNums.push_back('2');
                       ++i; break;
                  case '/':
                       vNums.push_back('3');
                       ++i; break;
                  case ')':
                       vNums.push_back('4');     
                       ++i; break;
            } // end switch
     }
}
void conv2strng(vector<char> &vNums, vector<char> &vStrng)  {
     int i = 0;
     vStrng.clear();
     while (i < vNums.size()) {
           switch (vNums[i]) {
                  case '1':
                       vStrng.push_back('1');
                       ++i; break;
                  case '2':
                       vStrng.push_back('(');
                       ++i; break;
                  case '3':
                       vStrng.push_back('/');
                       ++i; break;
                  case '4':
                       vStrng.push_back(')');     
                       ++i; break;
            } // end switch
     }
}
void getNblob(vector<char> &vChar, const char c[], int globGenus) {
    int n = 0, b_ctr = 1, paren_ctr = 0, x=0;
    char nextChar;
    vChar.push_back('1');
    do {     
          int i = rand()%4; 
          nextChar = c[i];
          switch(nextChar) {
               case '1':
                   vChar.push_back(nextChar);
                   ++n; ++b_ctr;
                   break;
               case '(':
                    if((vChar[n]!='/') && (b_ctr != globGenus - 1)) { 
                         ++paren_ctr;
                         vChar.push_back(nextChar);
                         ++n; ++b_ctr;
                    }
                    break;
               case '/':
                    // cout << "\nchecking vChar[" << n << "]=" << vChar[n];
                    // cout << " paren_ctr = " << paren_ctr;
                    if((paren_ctr>0) && (vChar[n]!='(') && (vChar[n] != '/')) {
                         vChar.push_back(nextChar);
                         ++n;
                    }
                    break;
               case ')':
                    if((paren_ctr>0) && (vChar[n]!='(') && (vChar[n]!='/')) {
                        vChar.push_back(nextChar);
                        --paren_ctr;
                        ++n;
                    }
                    break;
               default: break;
          } // end switch
        } while(b_ctr < globGenus);
        while(paren_ctr > 0) {
           vChar.push_back(')');
           --paren_ctr; 
        } //end while
        n = 0; b_ctr=1;
} //

void printVector(const vector< char > &v) {  
   std::vector<char>::const_iterator i = v.begin();
   cout << endl;
   for( ; i != v.end(); ++i) {
      cout << *i << " ";
   }
}
void writeVector(ostream &outfile, const vector< char > &v) {  
   std::vector<char>::const_iterator i = v.begin();
   outfile << endl;
   for( ; i != v.end(); ++i) {
      outfile << *i << " ";
   } outfile << endl;
}
