#include<iostream>
#include<ctime>
#include<cstdlib>
#include<vector>
#include<fstream>
#include <cmath>

using namespace std;
using std::ostream;
using std::ofstream;
using std::fstream;

void printVector(const vector<char> &);
void writeVector(ostream &, const vector<char> &);
void LoadTable(vector<vector<char> > &, int);
void getRevBlob(vector<char> &, vector<char> &);
void conv2nums(vector<char> &, vector<char> &);
void getLower(vector<char> &, vector<char> &);
void getCanForm(vector<char> &, vector<char> &);
void updateList(vector<vector<char> > &, vector<char> &, int);
void xlate(vector<char> &, vector<char> &, int);
void conv2strng(vector<char> &, vector<char> &);

int main() {
    int b_ndx, ii = 0, i, j, reset = 0, entry, guess, writeflag = 0;
    char xx;
    vector<char> vChar, vStrng, vlownum;
    vector<vector<char> > cforms, table;
    // open a file
    ofstream outBlob("blobs.txt", ios::out);
    if(!outBlob) { 
                 cerr << "\ndoh!" << endl;
                 exit(1);
    } 
    while(1) {
        cforms.clear();     
        entry = 0;
        while (entry == 0) {
              cout << endl << endl << "\nEnter number of regions: ";
              cin >> entry;
              if (entry == 0) {
                 writeflag = !writeflag;
                 if (writeflag) cout << endl << "File-writing turned on" << endl;
                 else cout << endl << "File-writing turned off" << endl;
              }   
        }                     
        b_ndx = entry - 1;
        ii = 0;
        LoadTable(table, b_ndx);
        while (ii < table.size()) {
           vChar = table[ii];
           getCanForm(vChar, vlownum);
           updateList(cforms, vlownum, reset);       
           ++ii;
        }

        j = 0;               
        if (writeflag) outBlob << "\nWith index " << entry << " and " << guess <<
                " guesses, found " << cforms.size() << " blobs: " << endl << endl;
        cout << endl;
        do {
           conv2strng(cforms[j], vStrng);
           if (j<9) cout << " " << j+1 << ".  ";
           else cout << j+1 << ".  ";
           printVector(vStrng); cout << endl; 
           if (writeflag) writeVector(outBlob, vStrng);
           ++j;
        } while (j < cforms.size());   
   }
}

void LoadTable(vector<vector<char> > &table, int n) {
   char ch;
   vector<char> vChar;
   vChar.push_back('1');
   vChar.push_back('(');
   vector<int> v_x;
   vector<int> v_y;  
   v_x.clear();
   v_y.clear();
   table.clear();
   // initialize coordinates
   v_x.push_back(0);
   v_y.push_back(1);
   table.push_back(vChar);
   bool done = 0;

   while(!done) { 
      done = 1;  // assume all are done
      for(unsigned int i = 0;i < table.size(); ++i) {
         if(v_x[i] < n) { // there's still one not done
            done = 0;
            if(v_y[i] < n) {  // below the top
               if(v_x[i] == v_y[i]) {  // on the diagonal so move up
                 // on the diagonal parens are balanced and no slashes occur
                 v_y[i] += 1;
		  		 table[i].push_back('('); //move up
               }
               else { // below top and left of diagonal AND LAST MOVE UP
            	  if(table[i].back() == '(') {
	 				 vector<char> newVChar(table[i]);
		    	     table[i].push_back('('); // go up
					 v_y[i] += 1;
	 				 newVChar.back() = '1'; // go right
	 				 table.push_back(newVChar);
	 				 v_x.push_back(v_x[i]+1);
	 				 v_y.push_back(v_y[i]-1);
				  }
								// interior AND LAST MOVE RIGHT...but not on diagonal		 
				  if(table[i].back() == ')') {
	 				 vector<char> newVChar(table[i]);
					 table[i].push_back('(');  //move up
					 v_y[i] += 1;
				     newVChar.push_back('/'); //move up with slash
				     newVChar.push_back('(');
				     table.push_back(newVChar);
				     v_x.push_back(v_x[i]);
				     v_y.push_back(v_y[i]);
				     newVChar.pop_back(); //move right
				     newVChar.back() =')';
				     table.push_back(newVChar);
				     v_x.push_back(v_x[i]+1);
				     v_y.push_back(v_y[i]-1);
                  }
				  if(table[i].back() == '1') {
					 vector<char> newVChar(table[i]);
					 table[i].push_back('(');  //move up-no slash
                     v_y[i] += 1;
					 newVChar.push_back('/'); //move up with slash`
					 newVChar.push_back('(');
					 table.push_back(newVChar);
					 v_x.push_back(v_x[i]);
			         v_y.push_back(v_y[i]);
					// move right
					 newVChar.pop_back();  // move right-no slash
					 newVChar.back() = ')';
					 table.push_back(newVChar);
					 v_x.push_back(v_x[i]+1);
					 v_y.push_back(v_y[i]-1);	
			      }
               } // end else
           } 
           else { //y_n = n
              if (table[i].back() == '(') {
				table[i].back() = '1';
				v_x[i] += 1;
		      }
              else  {  
                 table[i].push_back(')');
                 v_x[i] += 1;
	          }
           } // end else
        } // end if
      }  //end for
  }  // end while
//      cout << "\nThere are " << table.size() << " words, and here they are:" << endl;
//      cin >> ch;
//  for(int i = 0;i < table.size();++i) {
//     printVector(table[i]);
//     cout << endl;
//  }
//  cin >> ch;
}

// 'getCanForm' takes the input string 'vchar' and returns its 'canonical form,'
// e.g. the lowest number of all the xlate strings and their reversals that can 
// be made from all the '1's in vchar.  All strings are converted to numerical form
// first: '1' = 1, '(' = 2, '/' = 3, ')' = 4.

void getCanForm(vector<char> &vChar, vector<char> &vlownum) {
     int i = 1; char z;
     vector<char> vCharRev, vNums, vXlate;
     vXlate.clear(); vCharRev.clear(); 
     vNums.clear(); vlownum.clear();
//     printVector(vChar); //cout << " orig";
     for (int j=0; j < vChar.size(); ++j) vlownum.push_back('5');

     conv2nums(vChar, vNums);
     getLower(vNums, vlownum);
     getRevBlob(vChar, vCharRev);
     conv2nums(vCharRev, vNums);
     getLower(vNums, vlownum);
     while (i < vChar.size()) {       
           if (vChar[i] == '1') { 
              xlate(vChar, vXlate, i);
//              printVector(vChar);  cout << " orig";
              conv2nums(vXlate, vNums);
              getLower(vNums, vlownum);
              getRevBlob(vXlate, vCharRev);  
              conv2nums(vCharRev, vNums);
              getLower(vNums, vlownum);
//              cin >> z;
//              printVector(vXlate);  cout << " xlate pos. " << i+1;
//              cin >> z;
           }
           ++i;
     }            
//     printVector(vlownum);
}

// updateList takes the input string 'lownum' and checks it against 
// the list 'cforms'.  First, if the list is empty, is pushes lownum.  Next it 
// checks to see if lownum is greater than the last item on the list, in which
// case it pushes lownum onto the end.  If not, the iterator cfIt steps through 
// cforms until it finds an entry not less than lownum.  If this entry is greater
// than lownum then lownum is inserted into cforms at that spot.  If not then they
// must be equal and nothing is done.

void updateList(vector<vector<char> > &cforms, vector<char> &vlownum, int reset) {
     char z;
     vector<vector<char> >::iterator cfIt = cforms.begin();
     reset = 0;

     //cout << "cforms.size = " << cforms.size(); cin >> z;
     if (cforms.size() == 0) cforms.push_back(vlownum);
     else if(vlownum > *(cforms.end()-1)) cforms.push_back(vlownum);
     else {
//        for (int j = 0; j < cforms.size(); ++j) printVector(cforms[j]);
         while ((vlownum > *cfIt) && (cfIt != cforms.end())) ++cfIt;
         if (vlownum < *cfIt) {
           //cforms.push_back(vector<char>());
           cforms.insert(cfIt, 1, vlownum);
           reset = 1;
         }
     }               
//     cout << endl;
//     for (j = 0; j < cforms.size(); ++j) printVector(cforms[j]);
}

// 'xlate' Translates string 'vChar' from the perspective of the '1' in position i. 
// The string is translated from the innermost set of containing parenthesis out.
// 'rndx' and 'lndx' move left and right out from i.  'ss' tells if you: 0 - have not  
// yet hit a slash or containing paren, 1 - have hit a slash (so must cont. to 
// containing paren), or 2 - have hit the containing paren and are done with 
// current side of loop.  'ldone' and 'rdone' tell when the left or right end of 
// the string has been reached. 

void xlate(vector<char> &vChar, vector<char> &vXlate, int i) {
     int lndx, rndx, j, k, ss, rdone = 0, ldone = 0, dzp, max = vChar.size() - 1;
     vector<char> vNew;
     char x;
     vNew.clear(); vXlate.clear();
     for (j = 0; j <= max; ++j) {
         vXlate.push_back('0');
         vNew.push_back('0');  }
     vNew[0] = '1'; vNew[i] = '1';
     if (i == max) rdone = 1;
     else rndx = i + 1;
     if (i == 1) ldone = 1;
     else lndx = i - 1;
//     cout << "i = " << i << ", max = " << max << " rdone = " << rdone << " ldone = " << ldone;
//     cin >> x;
     do { // big loop
        if (!rdone) {
            ss = 0;
//            cout << endl << endl << "RIGHT SIDE";
            do {  // right side
               switch (vChar[rndx])  {
                      case '1':
                           vNew[rndx] = '1';
                           if (rndx == max) rdone = 1; 
                           else ++rndx;
                           break;
                      case '(':  //  a '(' going rt means there is a dead zone
                           vNew[rndx] = '(';
                           dzp = 1;
                           do {
                              ++rndx;
                              vNew[rndx] = vChar[rndx];
                              if (vChar[rndx] == '(') ++dzp;
                              if (vChar[rndx] == ')') --dzp;
//                              cout << "case '(' ";
//                              cout << endl << "rndx = " << rndx << "  ss = " << ss;
 //                             cout << endl << "dzp = " << dzp;
                           } while (dzp > 0);
                           if (rndx == max) rdone = 1; 
                           else ++rndx;
                           break;
                      case '/':
                           if (ss == 0) {
                              vNew[rndx] = '(';
                              ss = 1; }
                           else vNew[rndx] = '/';
                           ++rndx; 
                           break;
                      case ')':
                           if (ss == 0) vNew[rndx] = '(';
                           else vNew[rndx] = '/';
                           ss = 2;
                           if (rndx == max) rdone = 1; 
                           else ++rndx; 
                           break;
               }  // endswitch
//               cout << endl <<"rndx = " << rndx << " vChar[" << rndx << "] = " << vChar[rndx];         
//               cout << endl << "rdone = " << rdone << "    ldone = " << ldone;
//               cout << "   ss = " << ss;
//               printVector(vNew);
//               cout << endl; cin >> x;
            } while ((ss < 2) && (!rdone));
        }   //endif
        if (!ldone) {
            ss = 0;
//            cout << endl << endl << "LEFT SIDE"; cin >>x;
            do {  // left side       
               switch (vChar[lndx]) {
                      case '1': 
                           vNew[lndx] = vChar[lndx];
                           if (lndx == 1) ldone = 1;
                           if (lndx == 0) ldone = 1;
                           else --lndx;                            
                           break;
                      case ')':
                           vNew[lndx] = ')';
                           dzp = 1;
                           do  {
                               --lndx;
                               vNew[lndx] = vChar[lndx];
                               if (vChar[lndx] == ')') ++dzp;
                               if (vChar[lndx] == '(') --dzp;
//                              cout << "case ')' ";
//                              printVector(vChar); cout << "  vChar";
//                              printVector(vNew); cout << "  vNew";
//                              cout << endl << "lndx = " << lndx << "  ss = " << ss;
//                              cout << endl << "vChar[" << lndx << "] = " << vChar[lndx];
//                              cout << "  dzp = " << dzp;
//                              cin >> x;
                           } while (dzp > 0);
                           if (lndx == 1) ldone = 1;
                           else --lndx; 
                           break;
                      case '/':
                           if (ss == 0) {
                              vNew[lndx] = ')';
                              ss = 1;  }
                           else vNew[lndx] = '/';
                           --lndx; 
                           break;
                      case '(':
                           if (ss == 0) vNew[lndx] = ')';
                           else vNew[lndx] = '/';
                           ss = 2;
                           if(lndx == 1) ldone = 1; 
                           else --lndx;
                           break;
               }   //  end switch
//               cout << endl <<"lndx = " << lndx << " vChar[" << lndx << "] = " << vChar[lndx];          
//               cout << endl << "rdone = " << rdone << "    ldone = " << ldone;                
//               cout << "  ss = " << ss;
//               printVector(vNew);   
//               cout << endl;
//               cin >> x;    
            } while ((ss < 2) && (!ldone));        
        }  // endif
     } while ((!ldone) || (!rdone));
     for (k = 0; k <= max; ++k) 
         vXlate[k]= vNew[(k+i)% (max+1)];
}                                   

// 'getLower' replaces vlownum with vNums if vNums is lower. 

void getLower(vector<char> &vNums, vector<char> &vlownum)  {
     int i = 0, j,done = 0;
     do  {
             // cout << "vNums[" << i << "] = " << vNums[i];
             // cout << "  vlownum[" << i << "] = " << vlownum[i];
             // cout << endl;
             if (vNums[i] < vlownum[i]) {
                for (j = 0; j < vNums.size(); ++j) 
                    vlownum[j] = vNums[j];
                done = 1;
             }
             if (vNums[i] > vlownum[i]) done = 1;          
             if (i == vNums.size()) done = 1;
             ++i;
         } while (!done);
}     

void getRevBlob(vector<char> &vChar, vector<char> &vCharRev) {
     int i = 1, j = vChar.size();
     vCharRev.clear();
     vCharRev.push_back('1');
     while (i < j) {
           switch (vChar[j-i]) {
                 case '1':
                      vCharRev.push_back('1');
                      ++i; break;
                 case '(':   
                      vCharRev.push_back(')');
                      ++i; break;
                 case '/':
                      vCharRev.push_back('/');
                      ++i; break;
                 case ')':   
                      vCharRev.push_back('(');
                      ++i; break;     
            } // end switch          
     }
}

void conv2nums(vector<char> &vChar, vector<char> &vNums)  {
     int i = 0;
     vNums.clear();
     while (i < vChar.size()) {
           switch (vChar[i]) {
                  case '1':
                       vNums.push_back('1');
                       ++i; break;
                  case '(':
                       vNums.push_back('2');
                       ++i; break;
                  case '/':
                       vNums.push_back('3');
                       ++i; break;
                  case ')':
                       vNums.push_back('4');     
                       ++i; break;
            } // end switch
     }
}

void conv2strng(vector<char> &vNums, vector<char> &vStrng)  {
     int i = 0;
     vStrng.clear();
     while (i < vNums.size()) {
           switch (vNums[i]) {
                  case '1':
                       vStrng.push_back('1');
                       ++i; break;
                  case '2':
                       vStrng.push_back('(');
                       ++i; break;
                  case '3':
                       vStrng.push_back('/');
                       ++i; break;
                  case '4':
                       vStrng.push_back(')');     
                       ++i; break;
            } // end switch
     }
}

void printVector(const vector< char > &v) {  
   std::vector<char>::const_iterator i = v.begin();
//   cout << endl;
   for( ; i != v.end(); ++i) {
      cout << *i << " ";
   }
}

void writeVector(ostream &outfile, const vector< char > &v) {  
   std::vector<char>::const_iterator i = v.begin();
   outfile << endl;
   for( ; i != v.end(); ++i) {
      outfile << *i << " ";
   }
   outfile << endl;
}

