// Bernstein Globs

#include <gl/glut.h>
#include <iostream>
#include <iomanip>
#include <cmath>
using namespace std;

const GLfloat Pi = 3.14159265359;
void drawOutArc(GLfloat, GLfloat, GLfloat, GLfloat, GLfloat);
void drawInArc(GLfloat, GLfloat, GLfloat, GLfloat[2], GLfloat);


void drawOutArc(GLfloat h, GLfloat k, GLfloat r, GLfloat j, GLfloat n) {
	// create domain array
	glColor3f(0.0,0.5,0.2);  //glColor3i(r,g,bl);
	glBegin(GL_LINES);
   	  for(GLfloat t = 2*Pi*(j/n - 0.25); t <= 2*Pi*((j+1)/n + 0.25); t += 0.01) {
        glVertex2f(h+r*cos(t),k+r*sin(t));
		glVertex2f(h+r*cos(t+.01),k+r*sin(t+.01));  //Exercise: suggest better inc meth
	  }
	  cout << "\nh=" << h << "  k= " << k;
    glEnd();
	glFlush();
}


void drawInArc(GLfloat h, GLfloat k, GLfloat r, GLfloat arcs[2], GLfloat n) {
	// create domain array
	glColor3f(0.0,0.2,0.5);  //glColor3i(r,g,bl);
	glBegin(GL_LINES);
	if(arcs[1]/n + 0.25 < arcs[0]/n + 0.75) {
		for(GLfloat t = 2*Pi*(arcs[1]/n + 0.25); t <= 2*Pi*(arcs[0]/n + 0.75); t += 0.01) {
			glVertex2f(h+r*cos(t),k+r*sin(t));
			glVertex2f(h+r*cos(t+.01),k+r*sin(t+.01));  //Exercise: suggest better inc meth
		}
		cout << "\nh=" << h << "  k= " << k;
	}
	else {
		for(GLfloat t = 2*Pi*(arcs[0]/n + 0.75); t <= 2*Pi*(arcs[1]/n + 0.25); t += 0.01) {
			glVertex2f(h+r*cos(t),k+r*sin(t));
			glVertex2f(h+r*cos(t+.01),k+r*sin(t+.01));  //Exercise: suggest better inc meth
		}
		cout << "\nh=" << h << "  k= " << k;
	}
	glEnd();
	glFlush();
}

//<<<<<<<<<<<<<<<<<<<<<<< init >>>>>>>>>>>>>>>>>>>>
void init(void)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//set the viewing coordinates
	gluOrtho2D(-2.0, 2.0, -2.0, 2.0);//(-100, 100, -100, 100);
	glMatrixMode(GL_MODELVIEW);
	glClearColor(1.0,1.0,1.0,1.0); //(255,255,255,255); //white background
}


/* <<<<<<<<<<<<<<<<<<<< reshape >>>>>>>>>>>>>>>>>>>>>
void reshape(int w, int h) {
	glViewport(0,0, (GLsizei) w, (GLsizei) h );
	winWidth = w;
	winHeight = h;
	//glMatrixMode(GL_PROJECTION);
	//glLoadIdentity();
	//glOrtho(-2.0, 2.0, -2.0*(GLfloat) w / (GLfloat) w, 100.0);
	//glMatrixMode(GL_MODELVIEW);
	//glLoadIdentity();
}*/

//<<<<<<<<<<<<<<<<<<<<<<<< display >>>>>>>>>>>>>>>>>
void display(void)
{
	glClear(GL_COLOR_BUFFER_BIT); // clear the screen

	GLfloat center_x, center_y, radius, n, denominator;
	
	cout << "\nEnter the partition number for your glob: ";
	cin >> n;
	
	GLfloat deltaTheta = 2*Pi/n;
	denominator = sin(deltaTheta);
	for(GLfloat i = 0; i < n; ++i) {
		center_x = (sin(deltaTheta*(i+1))-sin(deltaTheta*i))/denominator;//50*
		center_y = (cos(deltaTheta*i)-cos(deltaTheta*(i+1)))/denominator;//50*
		radius = (1-cos(deltaTheta))/sin(deltaTheta);//50*
        drawOutArc(center_x, center_y, radius, i, n);
	}
	GLfloat arcs[6][2] = {{0,1},{2,8},{3,7},{4,6},{4,5},{5,6}};

	for(int i = 0; i < 6; ++i) {
		deltaTheta = 2*Pi*(arcs[i][1]-arcs[i][0])/n;
		denominator = sin(deltaTheta);
		center_x = (sin(2*Pi*arcs[i][1]/n)-sin(2*Pi*arcs[i][0]/n))/denominator;//50*
		center_y = (cos(2*Pi*arcs[i][0]/n)-cos(2*Pi*arcs[i][1]/n))/denominator;//50*
		radius = (1-cos(deltaTheta))/sin(deltaTheta);//50*
        drawInArc(center_x, center_y, radius, arcs[i], n);
	}
}


//<<<<<<<<<<<<<<<<<<<<<<<< main >>>>>>>>>>>>>>>>>>>>>>
int main(int argc, char** argv)
{
	glutInit(&argc, argv); // initialize the toolkit
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowSize(300,300); // set window size

	// set window position on screen
	glutInitWindowPosition(0, 435);
	// open the screen window and set the name
	glutCreateWindow("globs");
	//glutReshapeFunc(reshape);	
	//register your functions
	glutDisplayFunc(display);

	init();	
	glutMainLoop(); // go into a perpetual loop
}
